/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.security;

import com.ibm.hsc.security.HscPermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

final class HscPermissionCollection
extends PermissionCollection
implements Serializable {
    private Hashtable permissions = new Hashtable(11);
    private boolean canDoAll = false;

    public void add(Permission permission) {
        if (!(permission instanceof HscPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        HscPermission hscPermission = (HscPermission)permission;
        this.permissions.put(hscPermission.getName(), permission);
        if (!this.canDoAll && hscPermission.actionFlag == 0xFFFFFF) {
            this.canDoAll = true;
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof HscPermission)) {
            return false;
        }
        if (this.canDoAll) {
            return true;
        }
        HscPermission hscPermission = (HscPermission)permission;
        String string = hscPermission.getName();
        Permission permission2 = (Permission)this.permissions.get(string);
        if (permission2 != null) {
            return permission2.implies(hscPermission);
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

